
// ナビゲーションのハイライト設定
  document.addEventListener('DOMContentLoaded', function () {
    var currentPageUrl = window.location.pathname;
    var navLinks = document.querySelectorAll('nav a');

    navLinks.forEach(function (link) {
      if (link.getAttribute('href') === currentPageUrl) {
        link.classList.add('current');
      }
    });
  });


// サイドナビゲーションのハイライト設定 

  // セクションの表示状態をチェック
  function checkSectionVisibility() {
    var sections = document.querySelectorAll('.section');
    var windowHeight = window.innerHeight;

    sections.forEach(function (section) {
      var rect = section.getBoundingClientRect();
      var isVisible = rect.top <= windowHeight * 0.5 && rect.bottom >= windowHeight * 0.5;
      var navItem = document.querySelector('.nav-item[href="#' + section.id + '"]');

      if (isVisible) {
        navItem.classList.add('active');
      } else {
        navItem.classList.remove('active');
      }
    });
  }

  // ナビゲーションの文字色を変更する関数
  function changeActive(sectionId) {
    document.querySelectorAll('.nav-item').forEach(function (item) {
      item.classList.remove('active');
    });

    document.querySelector('.nav-item[href="#' + sectionId + '"]').classList.add('active');
  }

  // スクロール時にセクションの表示状態を確認
  window.addEventListener('scroll', function () {
    checkSectionVisibility();
  });

  // 初期化時にもセクションの表示状態を確認
  window.addEventListener('DOMContentLoaded', function () {
    checkSectionVisibility();
  });
  //  このスクリプトでは、セクションが画面の中央に表示されている場合にナビゲーションの文字色を変更し、次のセクションが画面の中央から上に表示されたら色を戻します。変更の瞬間にもアニメーションが適用されます。

  // ナビゲーションをクリックした際にセクションにスクロール
  function scrollToSection(sectionId) {
    var section = document.getElementById(sectionId);
    if (section) {
      var sectionTop = section.offsetTop - 110; // 110px上にスクロール
      window.scrollTo({ top: sectionTop, behavior: 'smooth' });
    }
  }

  // ナビゲーションの文字色を変更する関数
  function changeActive(sectionId) {
    document.querySelectorAll('.nav-item').forEach(function (item) {
      item.classList.remove('active');
    });

    document.querySelector('.nav-item[href="#' + sectionId + '"]').classList.add('active');
  }

  // ナビゲーションのリンクにクリックイベントを追加
  document.querySelectorAll('.nav-item').forEach(function (item) {
    item.addEventListener('click', function (event) {
      event.preventDefault();
      var sectionId = this.getAttribute('href').substring(1);
      scrollToSection(sectionId);
      changeActive(sectionId);
    });
  });

